package com.seniors.api.controller;

import com.seniors.commom.bo.UserBO;
import com.seniors.commom.constant.Constants;
import com.seniors.commom.utils.CommonUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.util.WebUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Objects;

/**
 * @author wangjinliang on 2018/10/9.
 */
public abstract class BaseRestController {
    @Autowired
    protected HttpServletRequest request;

    protected UserBO curUser() {
        return (UserBO) WebUtils.getSessionAttribute(request, Constants.B_USER_INFO);
    }

    protected long curUserId() {
        UserBO curUser = curUser();
        return Objects.nonNull(curUser) ? curUser.getId() : 0L;
    }

    protected String getUserAgent() {
        return StringUtils.defaultString(request.getHeader("User-Agent"));
    }

    protected String getIp() {
        return CommonUtils.getIpAddress(request);
    }

    protected String currentUrl() {
        return request.getScheme() + "://" + request.getServerName() + request.getServletPath();
    }

    protected String currentHost() {
        return request.getScheme() + "://" + request.getServerName();
    }

    protected String getDeviceId() {
        return StringUtils.defaultString(request.getHeader("device-id"));
    }
}
