package com.seniors.api.aspect;

import com.seniors.service.mapstruct.BeanMapStruct;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;

/**
 * @author wangjinliang
 */
@Aspect
@Component
public class LoginAspect {
    private final static String el = "@annotation(com.seniors.commom.annotation.LoginRequired)";

    @Autowired
    private BeanMapStruct beanMapStruct;
    @Autowired
    private HttpServletRequest request;
//    @Autowired
//    private CulturalUserLoginManager culturalUserLoginManager;

    @Before(LoginAspect.el)
    public void before() {
    }

    @Around(LoginAspect.el)
    public Object around(ProceedingJoinPoint p) throws Throwable {
//        MethodSignature methodSignature = (MethodSignature) p.getSignature();
//        Method method = methodSignature.getMethod();
//        LoginRequired annotation = method.getAnnotation(LoginRequired.class);
//        boolean exception = annotation.exception();
//        ErrorCodeException e = null;
//        String token = request.getHeader(CommunityConstants.ACCESS_TOKEN);
//        try {
//            if (StringUtils.isBlank(token)) {
//                throw TokenException.EMPTY;
//            } else {
//                CulturalUserLoginDO login = culturalUserLoginManager.getCulturalUserLoginByToken(token);
//                if (Objects.isNull(login)) {
//                    throw TokenException.ERROR;
//                }
//                Date tokenExpiredDate = login.getTokenExpiredTime();
//                if (ObjectUtils.compare(System.currentTimeMillis(), tokenExpiredDate.getTime()) < 0) {
//                    CulturalUserDO culturalUser = culturalUserLoginManager.getCulturalUserById(login.getUserId());
//                    if (culturalUser == null || culturalUser.getStatus() == 0) {
//                        throw new TokenException("账号不存在或已被冻结");
//                    }
//                    WebUtils.setSessionAttribute(request, CommunityConstants.B_USER_INFO, beanMapStruct.transfer2CUser(culturalUser));
//                } else {
//                    throw TokenException.EXPIRED;
//                }
//            }
//        } catch (TokenException ex) {
//            e = ex;
//        }
//        if (Objects.nonNull(e) && exception) {
//            throw e;
//        }
        return p.proceed();
    }

    @After(LoginAspect.el)
    public void after() {
    }
}
