package com.seniors.dao.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.core.env.Environment;

import javax.sql.DataSource;
import java.util.Properties;

/**
 * @author wangjinliang on 2018/9/28.
 */
@Slf4j
@Configuration
@PropertySources(value = {@PropertySource("file:${SENIORS_CONF_PATH}/db.properties")})
public class DataSourceConfig {
    @Autowired
    private Environment environment;

    @Bean
    public DataSource dataSource() {
        log.info("dataSource init start");
        Properties props = new Properties();
        props.setProperty("dataSourceClassName", environment.getRequiredProperty("dataSourceClassName"));
        props.setProperty("dataSource.user", environment.getRequiredProperty("dataSource.user"));
        props.setProperty("dataSource.password", environment.getRequiredProperty("dataSource.password"));
        props.setProperty("dataSource.databaseName", environment.getRequiredProperty("dataSource.databaseName"));
        props.setProperty("dataSource.serverName", environment.getRequiredProperty("dataSource.serverName"));
        props.setProperty("dataSource.portNumber", environment.getRequiredProperty("dataSource.portNumber"));
        props.setProperty("dataSource.cachePrepStmts", environment.getRequiredProperty("dataSource.cachePrepStmts"));
        props.setProperty("dataSource.prepStmtCacheSize", environment.getRequiredProperty("dataSource.prepStmtCacheSize"));
        props.setProperty("dataSource.prepStmtCacheSqlLimit", environment.getRequiredProperty("dataSource.prepStmtCacheSqlLimit"));
        props.setProperty("dataSource.useUnicode", "true");
        props.setProperty("dataSource.characterEncoding", "utf8");
        HikariConfig hikariConfig = new HikariConfig(props);
        String minimumIdle = environment.getRequiredProperty("dataSource.minimumIdle");
        String maximumPoolSize = environment.getRequiredProperty("dataSource.maximumPoolSize");
        if (StringUtils.isNotBlank(minimumIdle)) {
            hikariConfig.setMaximumPoolSize(Integer.parseInt(minimumIdle));
        }
        if (StringUtils.isNotBlank(maximumPoolSize)) {
            hikariConfig.setMinimumIdle(Integer.parseInt(maximumPoolSize));
        }
        log.info("dataSource init end");
        return new HikariDataSource(hikariConfig);
    }
}
